<cfsilent>
	
	<cfparam name="url.dataset" default="" />	
	

	<cfset dsn = application.blog.getProperty("dsn")>
	<cfset dbtype = application.blog.getProperty("blogdbtype")>
	<cfset blog = application.blog.getProperty("name")>
	<cfset username = application.blog.getProperty("username")>
	<cfset password = application.blog.getProperty("password")>
	
	<cfset dataset = url.dataset />
	<cfset outputXML = "" />
	<cfset theQuery = "" />
	
	<cfswitch expression="#dataset#">

	<cfcase value="BlogTotals">	
		<cfquery name="getTotalEntries" datasource="#dsn#" username="#username#" password="#password#">
			select	count(id) as totalentries, 
					min(posted) as firstentry,
					max(posted) as lastentry
			from	tblblogentries
			where 	tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
		</cfquery>

		<cfquery name="getTotalSubscribers" datasource="#dsn#" username="#username#" password="#password#">
			select	count(email) as totalsubscribers 
			from	tblblogsubscribers
			where 	tblblogsubscribers.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
			and		verified = 1
		</cfquery>
	
		<cfquery name="getTotalViews" datasource="#dsn#" username="#username#" password="#password#">
			select		sum(views) as total
			from		tblblogentries
			where 	tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
		</cfquery>
	
		<cfquery name="getTopViews" datasource="#dsn#" username="#username#" password="#password#">
			select		<cfif dbtype is not "mysql">top 10</cfif> id, title, views
			from		tblblogentries
			where 	tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
			order by	views desc
			<cfif dbtype is "mysql">limit 10</cfif>		
		</cfquery>
		
		<!--- get last 30 --->
		<cfset thirtyDaysAgo = dateAdd("d", -30, now())>
		<cfquery name="last30" datasource="#dsn#" username="#username#" password="#password#">
			select	count(id) as totalentries
			from	tblblogentries
			where 	tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
			and		posted >= <cfqueryparam cfsqltype="cf_sql_date" value="#thirtyDaysAgo#">
		</cfquery>
		
		<cfquery name="getTotalComments" datasource="#dsn#" username="#username#" password="#password#">
			select	count(tblblogcomments.id) as totalcomments
			from	tblblogcomments, tblblogentries
			where	tblblogcomments.entryidfk = tblblogentries.id
			and		tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
			<cfif application.commentmoderation>
			and		tblblogcomments.moderated = 1
			</cfif>
		</cfquery>
		
			<!--- RBB: 1/20/2006: get trackbacks --->
			<cfquery name="getTotalTrackbacks" datasource="#dsn#" username="#username#" password="#password#">
				select count(tblblogtrackbacks.id) as totaltrackbacks
				from	tblblogtrackbacks, tblblogentries
				where	tblblogtrackbacks.entryid = tblblogentries.id
				and		tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
			</cfquery>
			
			<cfset averageCommentsPerEntry = 0>	
			<cfif getTotalEntries.totalEntries>
				<cfset dur = dateDiff("d",getTotalEntries.firstEntry, now())>
				<cfset averageCommentsPerEntry = getTotalComments.totalComments / getTotalEntries.totalEntries>
			</cfif>
		
			<cfset TotalsQuery = QueryNew("Category,Amount") />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("totalnumentries") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", getTotalEntries.totalEntries) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("last30") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", last30.totalEntries) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("last30avg") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", iif(last30.totalentries gt 0, numberFormat(last30.totalEntries/30,"999.99"),"0") ) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("firstentry") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", iif( len(getTotalEntries.lastEntry), '#dateFormat(getTotalEntries.firstEntry,"mm/dd/yy")#', "") ) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("bloggingfor") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", iif(isDefined("dur"),  DE("#dur# #rb('days')#"),  "") ) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("totalcomments") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", getTotalComments.totalComments) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("avgcommentsperentry") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", numberFormat(averageCommentsPerEntry,"999.99") ) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("totaltrackbacks") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", getTotalTrackbacks.totalTrackbacks) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("totalviews") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", getTotalViews.total) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("avgviews") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", iif( gettotalentries.totalentries gt 0 and gettotalviews.total gt 0, numberFormat(gettotalviews.total/gettotalentries.totalentries,"999.99"), 0) ) />
			<cfset QueryAddRow( TotalsQuery ) />
			<cfset QuerySetCell( TotalsQuery, "Category", rb("totalsubscribers") ) />
			<cfset QuerySetCell( TotalsQuery, "Amount", getTotalSubscribers.totalsubscribers) />
			
			<cfset theQuery = TotalsQuery />
		</cfcase>
		<cfcase value="CategoryCount">
			<!--- gets num of entries per category --->
			<cfquery name="getCategoryCount" datasource="#dsn#" username="#username#" password="#password#">
				select	
					<cfif dbtype is not "mysql">top 10</cfif>
				categoryid, categoryname as Category, count(categoryidfk) as Amount
				from	tblblogcategories, tblblogentriescategories
				where	tblblogentriescategories.categoryidfk = tblblogcategories.categoryid
				and		tblblogcategories.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
				group by tblblogcategories.categoryid, Category
				<cfif dbtype is not "msaccess">
					order by Amount desc
				<cfelse>
					order by count(categoryidfk) desc
				</cfif>
				<cfif dbtype is "mysql">limit 10</cfif>
			</cfquery>
			<cfset theQuery = getCategoryCount />
		</cfcase>
		
		<cfcase value="CommentedEntries">
			<!--- gets num of comments per entry, top 10 --->
			<cfquery name="topCommentedEntries" datasource="#dsn#" username="#username#" password="#password#">
				select 
				<cfif dbtype is not "mysql">top 10</cfif>
				tblblogentries.id, tblblogentries.title as Category, count(tblblogcomments.id) as Amount
				from			tblblogentries, tblblogcomments
				where			tblblogcomments.entryidfk = tblblogentries.id
				and				tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
				<cfif application.commentmoderation>
				and				tblblogcomments.moderated = 1
				</cfif>
		
				group by		tblblogentries.id, Category
				<cfif dbtype is not "msaccess">
					order by	Amount desc
				<cfelse>
					order by 	count(tblblogcomments.id) desc
				</cfif>
				<cfif dbtype is "mysql">limit 10</cfif>
			</cfquery>
			<cfset theQuery = topCommentedEntries />
		</cfcase>
				

		<cfcase value="CommentedCategories">
			<!--- gets num of comments per category, top 10 --->
			<cfquery name="topCommentedCategories" datasource="#dsn#" username="#username#" password="#password#">
				select 
				<cfif dbtype is not "mysql">top 10</cfif>
								tblblogcategories.categoryid, 
								tblblogcategories.categoryname as Category, 
								count(tblblogcomments.id) as Amount
				from			tblblogcategories, tblblogcomments, tblblogentriescategories
				where			tblblogcomments.entryidfk = tblblogentriescategories.entryidfk
				and				tblblogentriescategories.categoryidfk = tblblogcategories.categoryid
				and				tblblogcategories.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
				<cfif application.commentmoderation>
				and				tblblogcomments.moderated = 1
				</cfif>		
				group by		tblblogcategories.categoryid, Category 
				<cfif dbtype is not "msaccess">
					order by	Amount desc
				<cfelse>
					order by	count(tblblogcomments.id) desc
				</cfif>
				<cfif dbtype is "mysql">limit 10</cfif>
			</cfquery>
			<cfset theQuery = topCommentedCategories />
		</cfcase>
		
		<cfcase value="TrackbackedEntries">
			<!--- RBB 1/20/2006: gets num of trackbacks per entry, top 10 --->
			<cfquery name="topTrackbackedEntries" datasource="#dsn#" username="#username#" password="#password#">
				select 
				<cfif dbtype is not "mysql">top 10</cfif>
				tblblogentries.id, tblblogentries.title as Category,  count(tblblogtrackbacks.id) as Amount
				from			tblblogentries, tblblogtrackbacks
				where			tblblogtrackbacks.entryid = tblblogentries.id
				and				tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
		
				group by		tblblogentries.id, Category
				<cfif dbtype is not "msaccess">
					order by	Amount desc
				<cfelse>
					order by 	count(tblblogtrackbacks.id) desc
				</cfif>
				<cfif dbtype is "mysql">limit 10</cfif>
			</cfquery>	
			<cfset theQuery = topTrackbackedEntries />
		</cfcase>

		<cfcase value="SearchTerms">
			<cfquery name="topSearchTerms" datasource="#dsn#" username="#username#" password="#password#">
				select		
				<cfif dbtype is not "mysql">top 10</cfif>
							searchterm AS Category, count(searchterm) as Amount
				from		tblblogsearchstats
				where		blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
				group by	searchterm
				<cfif dbtype is not "msaccess">
					order by	Amount desc
				<cfelse>
					order by	count(amount) desc
				</cfif>
				<cfif dbtype is "mysql">limit 10</cfif>
			</cfquery>
			<cfset theQuery = topSearchTerms />
		</cfcase>
		<cfcase value="Commenters">
			<cfquery name="topCommenters" datasource="#dsn#" username="#username#" password="#password#" maxrows="10">
				select	count(tblblogcomments.email) as Amount, email, tblblogcomments.name as Category
				from	tblblogcomments, tblblogentries
				where	tblblogcomments.entryidfk = tblblogentries.id
				and 	tblblogentries.blog = <cfqueryparam cfsqltype="cf_sql_varchar" value="#blog#">
				group by tblblogcomments.email, Category
				<cfif dbtype is not "msaccess">
				order by Amount desc
				<cfelse>
				order by count(tblblogcomments.email) desc
				</cfif>
			</cfquery>
			<cfset theQuery = topCommenters />
		</cfcase>
		
		<cfdefaultcase>
			<cfset theQuery = QueryNew("Category,Amount")>
		</cfdefaultcase>
	
	</cfswitch>


<cfscript>
/**
 * Generates an XMLDoc object from a basic CF Query.
 * 
 * @param query 	 The query to transform. (Required)
 * @param rootElement 	 Name of the root node. (Default is "query.") (Optional)
 * @param row 	 Name of each row. Default is "row." (Optional)
 * @param nodeMode 	 Defines the structure of the resulting XML.  Options are 1) "values" (default), which makes each value of each column mlText of individual nodes; 2) "columns", which makes each value of each column an attribute of a node for that column; 3) "rows", which makes each row a node, with the column names as attributes. (Optional)
 * @return Returns a string. 
 * @author Nathan Dintenfass (nathan@changemedia.com) 
 * @version 2, November 15, 2002 
 */
function queryToXML(query){
	//the default name of the root element
	var root = "query";
	//the default name of each row
	var row = "row";
	//make an array of the columns for looping
	var cols = listToArray(query.columnList);
	//which mode will we use?
	var nodeMode = "values";
	//vars for iterating
	var ii = 1;
	var rr = 1;
	//vars for holding the values of the current column and value
	var thisColumn = "";
	var thisValue = "";
	//a new xmlDoc
	var xml = xmlNew();
	//if there are 2 arguments, the second one is name of the root element
	if(structCount(arguments) GTE 2)
		root = arguments[2];
	//if there are 3 arguments, the third one is the name each element
	if(structCount(arguments) GTE 3)
		row = arguments[3];		
	//if there is a 4th argument, it's the nodeMode
	if(structCount(arguments) GTE 4)
		nodeMode = arguments[4]; 	
	//create the root node
	xml.xmlRoot = xmlElemNew(xml,root);
	//capture basic info in attributes of the root node
	xml[root].xmlAttributes["columns"] = arrayLen(cols);
	xml[root].xmlAttributes["rows"] = query.recordCount;
	//loop over the recordcount of the query and add a row for each one
	for(rr = 1; rr LTE query.recordCount; rr = rr + 1){
		arrayAppend(xml[root].xmlChildren,xmlElemNew(xml,row)); 
		//loop over the columns, populating the values of this row
		for(ii = 1; ii LTE arrayLen(cols); ii = ii + 1){
			thisColumn = lcase(cols[ii]);
			thisValue = query[cols[ii]][rr];
			switch(nodeMode){
				case "rows":
					xml[root][row][rr].xmlAttributes[thisColumn] = thisValue;
					break;
				case "columns":
					arrayAppend(xml[root][row][rr].xmlChildren,xmlElemNew(xml,thisColumn)); 
					xml[root][row][rr][thisColumn].xmlAttributes["value"] = thisValue;
					break;
				default:
					arrayAppend(xml[root][row][rr].xmlChildren,xmlElemNew(xml,thisColumn)); 
					xml[root][row][rr][thisColumn].xmlText = thisValue;						
			}

		}
	}
	//return the xmlDoc
	return xml;	
}
</cfscript>

</cfsilent><cfcontent reset="true" type="text/xml"><cfoutput>#queryToXML(theQuery)#</cfoutput>